<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('Biens_immobiliers', function(Blueprint $table) {
			$table->foreign('type_id')->references('id')->on('TypeBien')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Biens_immobiliers', function(Blueprint $table) {
			$table->foreign('Ville_id')->references('id')->on('Ville')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Biens_immobiliers', function(Blueprint $table) {
			$table->foreign('Propreitaire')->references('id')->on('Propreitaire')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Biens_immobiliers', function(Blueprint $table) {
			$table->foreign('agent_id')->references('id')->on('Agent')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Ville', function(Blueprint $table) {
			$table->foreign('idR')->references('id')->on('Region')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('visite', function(Blueprint $table) {
			$table->foreign('bien_id')->references('id')->on('Biens_immobiliers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('visite', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('User')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('visite', function(Blueprint $table) {
			$table->foreign('agent_id')->references('id')->on('Agent')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Ventes', function(Blueprint $table) {
			$table->foreign('bien_immobilier_id')->references('id')->on('Biens_immobiliers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Ventes', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('User')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Ventes', function(Blueprint $table) {
			$table->foreign('courtier_id')->references('id_courtier')->on('Courtier')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Ventes', function(Blueprint $table) {
			$table->foreign('agent_id')->references('id')->on('Agent')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Attributs_bien', function(Blueprint $table) {
			$table->foreign('attribut_id')->references('id')->on('Attributs')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Attributs_bien', function(Blueprint $table) {
			$table->foreign('bien_immobiliere_id')->references('id')->on('Biens_immobiliers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Image_bien', function(Blueprint $table) {
			$table->foreign('bien_id')->references('id')->on('Biens_immobiliers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Annonce', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('User')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Contact', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('User')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('Biens_immobiliers', function(Blueprint $table) {
			$table->dropForeign('Biens_immobiliers_type_id_foreign');
		});
		Schema::table('Biens_immobiliers', function(Blueprint $table) {
			$table->dropForeign('Biens_immobiliers_Ville_id_foreign');
		});
		Schema::table('Biens_immobiliers', function(Blueprint $table) {
			$table->dropForeign('Biens_immobiliers_Propreitaire_foreign');
		});
		Schema::table('Biens_immobiliers', function(Blueprint $table) {
			$table->dropForeign('Biens_immobiliers_agent_id_foreign');
		});
		Schema::table('Ville', function(Blueprint $table) {
			$table->dropForeign('Ville_idR_foreign');
		});
		Schema::table('visite', function(Blueprint $table) {
			$table->dropForeign('visite_bien_id_foreign');
		});
		Schema::table('visite', function(Blueprint $table) {
			$table->dropForeign('visite_client_id_foreign');
		});
		Schema::table('visite', function(Blueprint $table) {
			$table->dropForeign('visite_agent_id_foreign');
		});
		Schema::table('Ventes', function(Blueprint $table) {
			$table->dropForeign('Ventes_bien_immobilier_id_foreign');
		});
		Schema::table('Ventes', function(Blueprint $table) {
			$table->dropForeign('Ventes_client_id_foreign');
		});
		Schema::table('Ventes', function(Blueprint $table) {
			$table->dropForeign('Ventes_courtier_id_foreign');
		});
		Schema::table('Ventes', function(Blueprint $table) {
			$table->dropForeign('Ventes_agent_id_foreign');
		});
		Schema::table('Attributs_bien', function(Blueprint $table) {
			$table->dropForeign('Attributs_bien_attribut_id_foreign');
		});
		Schema::table('Attributs_bien', function(Blueprint $table) {
			$table->dropForeign('Attributs_bien_bien_immobiliere_id_foreign');
		});
		Schema::table('Image_bien', function(Blueprint $table) {
			$table->dropForeign('Image_bien_bien_id_foreign');
		});
		Schema::table('Annonce', function(Blueprint $table) {
			$table->dropForeign('Annonce_client_id_foreign');
		});
		Schema::table('Contact', function(Blueprint $table) {
			$table->dropForeign('Contact_client_id_foreign');
		});
	}
}