<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->bigIncrements('id', true);
			$table->bigInteger('code')->unique();
			$table->double('subtotal')->nullable();
			$table->double('discount')->nullable();
			$table->double('tax')->nullable();
			$table->double('service_fees')->nullable();
			$table->double('delivery_fees')->nullable();
			$table->double('total')->nullable();
			$table->boolean('paid')->default(1);
			$table->tinyInteger('source')->default('1');
			$table->tinyInteger('payment_method')->default('1');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}