<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCashierShiftsTable extends Migration {

	public function up()
	{
		Schema::create('cashier_shifts', function(Blueprint $table) {
			$table->bigIncrements('id', true);
			$table->bigInteger('cashier_id')->unsigned()->index();
			$table->bigInteger('manager_id')->unsigned()->nullable()->index();
			$table->double('start_cash');
			$table->double('end_cash')->nullable();
			$table->double('cash_status')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('cashier_shifts');
	}
}