<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('product_size', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('product_size', function(Blueprint $table) {
			$table->foreign('size_id')->references('id')->on('sizes')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('product_pictures', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('product_pictures', function(Blueprint $table) {
			$table->foreign('picture_id')->references('id')->on('pictures')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('combo_items', function(Blueprint $table) {
			$table->foreign('combo_id')->references('id')->on('combos')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('combo_items', function(Blueprint $table) {
			$table->foreign('product_size_id')->references('id')->on('product_size')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('combo_Item_options', function(Blueprint $table) {
			$table->foreign('combo_items_id')->references('id')->on('combo_items')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('combo_Item_options', function(Blueprint $table) {
			$table->foreign('product_size_id')->references('id')->on('product_size')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('menu_classification_products', function(Blueprint $table) {
			$table->foreign('classification_id')->references('id')->on('menu_classifications')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('menu_classification_products', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('product_size_ingredients', function(Blueprint $table) {
			$table->foreign('product_size_id')->references('id')->on('product_size')
						->onDelete('restrict')
						->onUpdate('no action');
		});
		Schema::table('product_size_ingredients', function(Blueprint $table) {
			$table->foreign('ingredient_id')->references('id')->on('ingredients')
						->onDelete('restrict')
						->onUpdate('no action');
		});
		Schema::table('product_size_ingredients', function(Blueprint $table) {
			$table->foreign('measuring_unit_id')->references('id')->on('measuring_units')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('categories', function(Blueprint $table) {
			$table->foreign('picture_id')->references('id')->on('pictures')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('branch_inventory', function(Blueprint $table) {
			$table->foreign('inventory_id')->references('id')->on('inventory')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('branch_inventory', function(Blueprint $table) {
			$table->foreign('branch_id')->references('id')->on('branches')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('branch_inventory_ingredients', function(Blueprint $table) {
			$table->foreign('branch_inventory_id')->references('id')->on('branch_inventory')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('branch_inventory_ingredients', function(Blueprint $table) {
			$table->foreign('ingredient_id')->references('id')->on('ingredients')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('branch_inventory_ingredients', function(Blueprint $table) {
			$table->foreign('measuring_unit_id')->references('id')->on('measuring_units')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('branch_categories', function(Blueprint $table) {
			$table->foreign('branch_id')->references('id')->on('branches')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('branch_categories', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('branch_category_products', function(Blueprint $table) {
			$table->foreign('branch_category_id')->references('id')->on('branch_categories')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('branch_category_products', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('cashiers', function(Blueprint $table) {
			$table->foreign('branch_id')->references('id')->on('branches')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('managers', function(Blueprint $table) {
			$table->foreign('branch_id')->references('id')->on('branches')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('cashier_shifts', function(Blueprint $table) {
			$table->foreign('cashier_id')->references('id')->on('cashiers')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('cashier_shifts', function(Blueprint $table) {
			$table->foreign('manager_id')->references('id')->on('managers')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('cashier_shift_orders', function(Blueprint $table) {
			$table->foreign('cashier_shift_id')->references('id')->on('cashier_shifts')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('cashier_shift_orders', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('order_products', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('order_products')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('order_products', function(Blueprint $table) {
			$table->foreign('product_size_id')->references('id')->on('product_size')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('order_products', function(Blueprint $table) {
			$table->foreign('combo_id')->references('id')->on('combos')
						->onDelete('cascade')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('product_size', function(Blueprint $table) {
			$table->dropForeign('product_size_product_id_foreign');
		});
		Schema::table('product_size', function(Blueprint $table) {
			$table->dropForeign('product_size_size_id_foreign');
		});
		Schema::table('product_pictures', function(Blueprint $table) {
			$table->dropForeign('product_pictures_product_id_foreign');
		});
		Schema::table('product_pictures', function(Blueprint $table) {
			$table->dropForeign('product_pictures_picture_id_foreign');
		});
		Schema::table('combo_items', function(Blueprint $table) {
			$table->dropForeign('combo_items_combo_id_foreign');
		});
		Schema::table('combo_items', function(Blueprint $table) {
			$table->dropForeign('combo_items_product_size_id_foreign');
		});
		Schema::table('combo_Item_options', function(Blueprint $table) {
			$table->dropForeign('combo_Item_options_combo_items_id_foreign');
		});
		Schema::table('combo_Item_options', function(Blueprint $table) {
			$table->dropForeign('combo_Item_options_product_size_id_foreign');
		});
		Schema::table('menu_classification_products', function(Blueprint $table) {
			$table->dropForeign('menu_classification_products_classification_id_foreign');
		});
		Schema::table('menu_classification_products', function(Blueprint $table) {
			$table->dropForeign('menu_classification_products_product_id_foreign');
		});
		Schema::table('product_size_ingredients', function(Blueprint $table) {
			$table->dropForeign('product_size_ingredients_product_size_id_foreign');
		});
		Schema::table('product_size_ingredients', function(Blueprint $table) {
			$table->dropForeign('product_size_ingredients_ingredient_id_foreign');
		});
		Schema::table('product_size_ingredients', function(Blueprint $table) {
			$table->dropForeign('product_size_ingredients_measuring_unit_id_foreign');
		});
		Schema::table('categories', function(Blueprint $table) {
			$table->dropForeign('categories_picture_id_foreign');
		});
		Schema::table('branch_inventory', function(Blueprint $table) {
			$table->dropForeign('branch_inventory_inventory_id_foreign');
		});
		Schema::table('branch_inventory', function(Blueprint $table) {
			$table->dropForeign('branch_inventory_branch_id_foreign');
		});
		Schema::table('branch_inventory_ingredients', function(Blueprint $table) {
			$table->dropForeign('branch_inventory_ingredients_branch_inventory_id_foreign');
		});
		Schema::table('branch_inventory_ingredients', function(Blueprint $table) {
			$table->dropForeign('branch_inventory_ingredients_ingredient_id_foreign');
		});
		Schema::table('branch_inventory_ingredients', function(Blueprint $table) {
			$table->dropForeign('branch_inventory_ingredients_measuring_unit_id_foreign');
		});
		Schema::table('branch_categories', function(Blueprint $table) {
			$table->dropForeign('branch_categories_branch_id_foreign');
		});
		Schema::table('branch_categories', function(Blueprint $table) {
			$table->dropForeign('branch_categories_category_id_foreign');
		});
		Schema::table('branch_category_products', function(Blueprint $table) {
			$table->dropForeign('branch_category_products_branch_category_id_foreign');
		});
		Schema::table('branch_category_products', function(Blueprint $table) {
			$table->dropForeign('branch_category_products_product_id_foreign');
		});
		Schema::table('cashiers', function(Blueprint $table) {
			$table->dropForeign('cashiers_branch_id_foreign');
		});
		Schema::table('managers', function(Blueprint $table) {
			$table->dropForeign('managers_branch_id_foreign');
		});
		Schema::table('cashier_shifts', function(Blueprint $table) {
			$table->dropForeign('cashier_shifts_cashier_id_foreign');
		});
		Schema::table('cashier_shifts', function(Blueprint $table) {
			$table->dropForeign('cashier_shifts_manager_id_foreign');
		});
		Schema::table('cashier_shift_orders', function(Blueprint $table) {
			$table->dropForeign('cashier_shift_orders_cashier_shift_id_foreign');
		});
		Schema::table('cashier_shift_orders', function(Blueprint $table) {
			$table->dropForeign('cashier_shift_orders_order_id_foreign');
		});
		Schema::table('order_products', function(Blueprint $table) {
			$table->dropForeign('order_products_order_id_foreign');
		});
		Schema::table('order_products', function(Blueprint $table) {
			$table->dropForeign('order_products_product_size_id_foreign');
		});
		Schema::table('order_products', function(Blueprint $table) {
			$table->dropForeign('order_products_combo_id_foreign');
		});
	}
}