<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrderProductsTable extends Migration {

	public function up()
	{
		Schema::create('order_products', function(Blueprint $table) {
			$table->bigIncrements('id', true);
			$table->bigInteger('order_id')->unsigned()->index();
			$table->bigInteger('product_size_id')->unsigned()->index();
			$table->smallInteger('quantity');
			$table->double('subtotal')->nullable();
			$table->double('discount')->nullable();
			$table->bigInteger('combo_id')->unsigned()->index();
			$table->double('product_size_price');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('order_products');
	}
}