<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBackendUsersTable extends Migration {

	public function up()
	{
		Schema::create('backend_users', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->string('name', 32)->nullable();
			$table->string('email')->unique();
			$table->string('username', 32)->unique();
			$table->string('password')->nullable();
			$table->boolean('status')->default(false);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('backend_users');
	}
}