<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateActivationCodesTable extends Migration {

	public function up()
	{
		Schema::create('activation_codes', function(Blueprint $table) {
			$table->bigIncrements('id', true);
			$table->integer('user_id');
			$table->integer('user_type');
			$table->string('code', 64)->unique();
			$table->boolean('used')->default(false);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('activation_codes');
	}
}