<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('messages', function(Blueprint $table) {
			$table->foreign('chat_id')->references('id')->on('chat')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('messages', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('files', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('user_chats', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('user_chats', function(Blueprint $table) {
			$table->foreign('chat_id')->references('id')->on('chat')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('message_files', function(Blueprint $table) {
			$table->foreign('file_id')->references('id')->on('files')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('message_files', function(Blueprint $table) {
			$table->foreign('message_id')->references('id')->on('messages')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('storages', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('files_in_storages', function(Blueprint $table) {
			$table->foreign('file_id')->references('id')->on('files')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('files_in_storages', function(Blueprint $table) {
			$table->foreign('storage_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('messages', function(Blueprint $table) {
			$table->dropForeign('messages_chat_id_foreign');
		});
		Schema::table('messages', function(Blueprint $table) {
			$table->dropForeign('messages_user_id_foreign');
		});
		Schema::table('files', function(Blueprint $table) {
			$table->dropForeign('files_user_id_foreign');
		});
		Schema::table('user_chats', function(Blueprint $table) {
			$table->dropForeign('user_chats_user_id_foreign');
		});
		Schema::table('user_chats', function(Blueprint $table) {
			$table->dropForeign('user_chats_chat_id_foreign');
		});
		Schema::table('message_files', function(Blueprint $table) {
			$table->dropForeign('message_files_file_id_foreign');
		});
		Schema::table('message_files', function(Blueprint $table) {
			$table->dropForeign('message_files_message_id_foreign');
		});
		Schema::table('storages', function(Blueprint $table) {
			$table->dropForeign('storages_user_id_foreign');
		});
		Schema::table('files_in_storages', function(Blueprint $table) {
			$table->dropForeign('files_in_storages_file_id_foreign');
		});
		Schema::table('files_in_storages', function(Blueprint $table) {
			$table->dropForeign('files_in_storages_storage_id_foreign');
		});
	}
}