<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    public function userMassages()
    {
        return $this->hasMany('Messages', 'user_id');
    }

    public function userChats()
    {
        return $this->belongsToMany('Chat', 'user_chats', 'user_id', 'chat_id');
    }

    public function userStorage()
    {
        return $this->hasOne('Storage');
    }

}