<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Files extends Model 
{

    protected $table = 'files';
    public $timestamps = true;

    public function fileInStorages()
    {
        return $this->belongsToMany('Storage', 'files_in_storage', 'file_id', 'storage_id');
    }

    public function messages()
    {
        return $this->belongsToMany('Messages', 'message_files', 'file_id', 'message_id')->withPivot('full_name', 'created_at');
    }

}