<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCarTypesTable extends Migration {

	public function up()
	{
		Schema::create('car_types', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 200);
			$table->longText('description')->nullable();
			$table->datetime('create_at');
			$table->datetime('update_at')->nullable();
			$table->integer('update_by')->unsigned()->nullable();
			$table->integer('create_by')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('car_types');
	}
}