<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBlockTemplatesTable extends Migration {

	public function up()
	{
		Schema::create('block_templates', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('site_user_id')->unsigned()->index();
			$table->string('name')->index();
			$table->text('description');
			$table->string('status')->default('draft');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('block_templates');
	}
}