<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTiersTable extends Migration {

	public function up()
	{
		Schema::create('tiers', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name')->unique();
			$table->longText('description')->nullable();
			$table->decimal('usd_price', 10, 2);
			$table->decimal('egp_price', 10, 2);
			$table->decimal('commission', 5, 2);
		});
	}

	public function down()
	{
		Schema::drop('tiers');
	}
}