<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEndpointsTable extends Migration {

	public function up()
	{
		Schema::create('endpoints', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('customer_id')->unsigned();
			$table->enum('type', array('SMS', 'EMAIL', 'DEVICE'))->index();
			$table->string('code');
			$table->string('token');
		});
	}

	public function down()
	{
		Schema::drop('endpoints');
	}
}