<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class TicketLife extends Model 
{

    protected $table = 'ticketLife';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function ticket()
    {
        return $this->belongsTo('Ticket', 'id');
    }

    public function user()
    {
        return $this->belongsTo('User', 'id');
    }

}