<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePlanLimitationsTable extends Migration {

	public function up()
	{
		Schema::create('plan_limitations', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name')->nullable();
			$table->string('plan_ids', 255);
			$table->string('title', 255)->nullable();
			$table->text('description');
			$table->integer('order')->nullable();
			$table->string('pricing_desc', 255)->nullable();
			$table->string('price_equation')->nullable();
			$table->string('minimum_allowed', 255)->nullable();
			$table->integer('includes')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('plan_limitations');
	}
}