<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLimitationsTable extends Migration {

	public function up()
	{
		Schema::create('limitations', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name')->nullable();
			$table->text('title');
			$table->string('image')->primary();
			$table->integer('order');
		});
	}

	public function down()
	{
		Schema::drop('limitations');
	}
}