<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Agent extends Eloquent {

	protected $table = 'agents';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function myBranch()
	{
		return $this->belongsTo('App\Models\Branch', 'branch_id');
	}

	public function myClients()
	{
		return $this->belongsToMany('App\Models\Client', 'agents_id');
	}

}