<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateClientsTable extends Migration {

	public function up()
	{
		Schema::create('clients', function(Blueprint $table) {
			$table->increments('id');
			$table->enum('status', array('ACTIVE', 'INACTIVE'))->default('INACTIVE');
			$table->integer('agents_id')->unsigned()->index();
			$table->integer('branch_id')->unsigned();
			$table->string('first_name', 100);
			$table->string('last_name', 100);
			$table->string('middle_name', 100);
			$table->string('nick_name', 100);
			$table->enum('sex', array('FEMALE', 'MALE'));
			$table->enum('civil_status', array('SINGLE', 'MARRIED', 'WIDOWED', 'DIVORCED'));
			$table->integer('provinces_id')->unsigned()->index();
			$table->integer('municipalities_id')->unsigned()->index();
			$table->integer('barangay_id')->unsigned();
			$table->text('address');
			$table->integer('identification_type_id')->unsigned()->index();
			$table->string('identification_number', 100);
			$table->date('birth_day');
			$table->text('birth_place');
			$table->string('occupation', 100);
			$table->string('contact_number', 11);
			$table->integer('religion_id')->unsigned();
			$table->string('payor_first_name', 100);
			$table->string('payor_last_name', 100);
			$table->string('payor_middle_name', 100);
			$table->integer('payor_provinces_id')->unsigned();
			$table->integer('payor_municipalities_id')->unsigned();
			$table->integer('payor_barangay_id')->unsigned();
			$table->string('payor_address', 255);
			$table->date('payor_birth_day');
			$table->integer('payor_relation_id')->unsigned();
			$table->string('payor_contact_number', 11);
			$table->text('beneficiaries');
			$table->softDeletes();
			$table->timestamps();
			$table->text('profile_image')->nullable();
			$table->text('documents');
		});
	}

	public function down()
	{
		Schema::drop('clients');
	}
}