<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAgentsTable extends Migration {

	public function up()
	{
		Schema::create('agents', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('parent_agents_id')->unsigned()->nullable();
			$table->enum('rank', array('RA', 'FFSO', 'BM'));
			$table->integer('branch_id')->unsigned();
			$table->string('first_name', 100);
			$table->string('last_name', 100);
			$table->string('middle_name', 100);
			$table->string('nick_name', 100);
			$table->string('contact_number', 11);
			$table->enum('sex', array('FEMALE', 'MALE'));
			$table->date('birth_day');
			$table->enum('civil_status', array('SINGLE', 'MARRIED', 'WIDOWED', 'DIVORCED'));
			$table->string('occupation', 100);
			$table->integer('religion_id')->unsigned();
			$table->string('spouse', 100);
			$table->integer('provinces_id')->unsigned()->index();
			$table->integer('municipalities_id')->unsigned()->index();
			$table->integer('barangay_id')->unsigned()->index();
			$table->text('address');
			$table->string('fathers_name', 255);
			$table->string('fathers_occupation', 100);
			$table->string('mothers_name', 255);
			$table->string('mothers_occupation', 100);
			$table->text('parent_address');
			$table->string('dialect', 100);
			$table->string('contact_person', 100);
			$table->text('person_contact_address');
			$table->string('contact_person_number', 11);
			$table->text('elementary_school');
			$table->text('high_school');
			$table->text('college_school');
			$table->date('elementary_yr_grad');
			$table->date('high_yr_grad');
			$table->date('college_yr_grad');
			$table->string('cedula_no', 100);
			$table->string('cedula_issued_at', 255);
			$table->date('cedula_issued_date');
			$table->string('tin_no', 100);
			$table->string('sss_gsis_no', 100);
			$table->string('nbi_no', 100);
			$table->string('blood_type', 3);
			$table->text('beneficiaries');
			$table->text('character_reference');
			$table->text('employment_records');
			$table->text('profile_image')->nullable();
			$table->text('documents')->nullable();
			$table->enum('status', array('ACTIVE', 'INACTIVE'))->default('INACTIVE');
			$table->enum('verification_status', array('PENDING', 'VERIFIED'))->default('PENDING');
			$table->integer('users_id')->index();
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('agents');
	}
}