<?php

namespace App\Models;

class Client extends Eloquent {

	protected $table = 'clients';
	public $timestamps = true;
	protected $fillable = array('name', 'email', 'phone', 'password', 'address_id');

	public function regions()
	{
		return $this->belongsTo('App\Models\Region');
	}

	public function ratings()
	{
		return $this->belongsToMany('App\Models\Review');
	}

	public function orders()
	{
		return $this->belongsToMany('App\Models\Order');
	}

	public function notifications()
	{
		return $this->belongsToMany('App\Models\Notification');
	}

}