<?php

namespace App\Models;

class Client extends Eloquent {

	protected $table = 'clients';
	public $timestamps = true;
	protected $fillable = array('name', 'email', 'dob', 'last_donation_date', 'phone_number', 'password', 'blood_type_id', 'city_id');
	protected $hidden = array('password');

	public function bloodType()
	{
		return $this->belongsTo('App\Models\BloodType');
	}

	public function city()
	{
		return $this->belongsTo('App\Models\City');
	}

	public function favouritedPosts()
	{
		return $this->morphedByMany('App\Models\Post', 'clientable');
	}

	public function allowedGovernoratesForNotification()
	{
		return $this->morphedByMany('App\Models\Governorate', 'clientable');
	}

	public function allowedBloodTypesForNotification()
	{
		return $this->morphedByMany('App\Models\BloodType', 'clientable');
	}

}