<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Project extends Eloquent {

	protected $table = 'projects';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function faq()
	{
		return $this->hasMany('Faq');
	}

	public function tickets()
	{
		return $this->hasMany('Ticket');
	}

	public function licenses()
	{
		return $this->hasMany('License');
	}

}