<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function comments()
    {
        return $this->hasMany('Comment');
    }

    public function roles()
    {
        return $this->belongsToMany('Role')->withPivot('role_user');
    }

    public function licenses()
    {
        return $this->hasMany('License');
    }

    public function tickets()
    {
        return $this->hasMany('Ticket');
    }

}