<?php

namespace Models/OffersDetails;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class OffersDetails extends Model 
{

    protected $table = 'offers_details';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function course()
    {
        return $this->belongsTo('Courses', 'course_id');
    }

    public function offer()
    {
        return $this->belongsTo('Offers', 'offer_id');
    }

}