<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateIntervalsTable extends Migration {

	public function up()
	{
		Schema::create('intervals', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('country_id')->unsigned()->nullable();
			$table->integer('currency_id')->unsigned()->nullable();
			$table->string('slug')->nullable();
			$table->decimal('min', 15,2)->nullable();
			$table->decimal('max', 15,2)->nullable();
			$table->string('default', 10)->nullable()->default('0');
			$table->string('status', 10)->nullable()->default('0');
		});
	}

	public function down()
	{
		Schema::drop('intervals');
	}
}