<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateApplicationsTable extends Migration {

	public function up()
	{
		Schema::create('applications', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('application_name', 255)->unique();
			$table->integer('moduleid');
			$table->tinyInteger('status');
			$table->string('route', 255);
			$table->string('icon', 255);
		});
	}

	public function down()
	{
		Schema::drop('applications');
	}
}