<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEventsTable extends Migration {

	public function up()
	{
		Schema::create('events', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title');
			$table->string('image');
			$table->text('description');
			$table->json('themes_id')->nullable();
			$table->datetime('date');
			$table->string('location')->nullable();
			$table->datetime('scheduled_publish_date')->nullable();
			$table->boolean('active')->default(1);
			$table->integer('club_id')->unsigned();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('events');
	}
}