<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRecordingLogTable extends Migration {

	public function up()
	{
		Schema::create('recording_log', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('dealer_id');
			$table->tinyInteger('call_type')->default('0');
			$table->integer('company_id')->default('0');
			$table->string('first_name', 256)->nullable();
			$table->string('last_name', 256)->nullable();
			$table->string('phone', 191);
			$table->string('call_duration', 191);
			$table->timestamp('call_start_time');
			$table->timestamp('call_end_time');
			$table->string('recording_file', 256);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('recording_log');
	}
}