<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title');
			$table->string('description');
			$table->string('main_category');
			$table->bigInteger('boutique')->unsigned();
			$table->string('status');
			$table->string('price');
			$table->string('offer_price')->nullable();
			$table->string('slider_images');
			$table->string('cover_image');
			$table->string('in_stock_quantity');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}