<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCustomersTable extends Migration {

	public function up()
	{
		Schema::create('customers', function(Blueprint $table) {
			$table->increments('id', true);
			$table->integer('company_id')->unsigned();
			$table->integer('user_id')->unsigned();
			$table->string('name', 255);
			$table->string('email', 255);
			$table->string('phone', 255);
			$table->string('address', 255);
			$table->string('website', 255);
			$table->tinyInteger('status');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('customers');
	}
}