<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Allocations extends Eloquent {

	protected $table = 'allocations';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('time', 'task', 'priority', 'project_id', 'created_by', 'updated_by');

	public function getProject()
	{
		return $this->hasOne('Projects', 'project_id');
	}

	public function getUser()
	{
		return $this->hasOne('User', 'user_id');
	}

}