<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAllocationsTable extends Migration {

	public function up()
	{
		Schema::create('allocations', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->datetime('time');
			$table->string('task', 255);
			$table->string('priority', 255);
			$table->integer('project_id')->unsigned();
			$table->string('created_by', 255);
			$table->string('updated_by', 255);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('allocations');
	}
}