<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePaymentsTable extends Migration {

	public function up()
	{
		Schema::create('payments', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('user_id')->unsigned();
			$table->bigInteger('booking_id')->unsigned();
			$table->integer('discount_percentage')->nullable()->default('0');
			$table->decimal('discount_amount')->default('0');
			$table->double('total_amount');
			$table->double('amount');
			$table->tinyInteger('payment_status')->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('payments');
	}
}