<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRatesTable extends Migration {

	public function up()
	{
		Schema::create('rates', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('rate');
			$table->timestamps();
			$table->integer('moderator_id')->unsigned();
			$table->integer('employee_id')->unsigned();
			$table->enum('related_type', array('student', 'employee'));
			$table->timestamps();
			$table->integer('student_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('rates');
	}
}