<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('words', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('word_answers', function(Blueprint $table) {
			$table->foreign('word_id')->references('id')->on('words')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('lessons', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('lessons', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('lesson_words', function(Blueprint $table) {
			$table->foreign('word_id')->references('id')->on('words')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('lesson_words', function(Blueprint $table) {
			$table->foreign('word_answer_id')->references('id')->on('word_answers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('lesson_words', function(Blueprint $table) {
			$table->foreign('lesson_id')->references('id')->on('lessons')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_relationships', function(Blueprint $table) {
			$table->foreign('follower_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_relationships', function(Blueprint $table) {
			$table->foreign('following_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_activities', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_role', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('user_role', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('words', function(Blueprint $table) {
			$table->dropForeign('words_category_id_foreign');
		});
		Schema::table('word_answers', function(Blueprint $table) {
			$table->dropForeign('word_answers_word_id_foreign');
		});
		Schema::table('lessons', function(Blueprint $table) {
			$table->dropForeign('lessons_user_id_foreign');
		});
		Schema::table('lessons', function(Blueprint $table) {
			$table->dropForeign('lessons_category_id_foreign');
		});
		Schema::table('lesson_words', function(Blueprint $table) {
			$table->dropForeign('lesson_words_word_id_foreign');
		});
		Schema::table('lesson_words', function(Blueprint $table) {
			$table->dropForeign('lesson_words_word_answer_id_foreign');
		});
		Schema::table('lesson_words', function(Blueprint $table) {
			$table->dropForeign('lesson_words_lesson_id_foreign');
		});
		Schema::table('user_relationships', function(Blueprint $table) {
			$table->dropForeign('user_relationships_follower_id_foreign');
		});
		Schema::table('user_relationships', function(Blueprint $table) {
			$table->dropForeign('user_relationships_following_id_foreign');
		});
		Schema::table('user_activities', function(Blueprint $table) {
			$table->dropForeign('user_activities_user_id_foreign');
		});
		Schema::table('user_role', function(Blueprint $table) {
			$table->dropForeign('user_role_user_id_foreign');
		});
		Schema::table('user_role', function(Blueprint $table) {
			$table->dropForeign('user_role_role_id_foreign');
		});
	}
}