<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateApplicationFilesTable extends Migration {

	public function up()
	{
		Schema::create('application_files', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('application_id')->unsigned();
			$table->string('file_name')->unique();
			$table->string('type');
			$table->longText('description')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('application_files');
	}
}