<?php

namespace App\Models;

class MenuItem extends Eloquent {

	protected $table = 'menu_items';
	public $timestamps = true;

	public function menuSection()
	{
		return $this->belongsTo('App\Models\MenuSection');
	}

	public function resturantOrders()
	{
		return $this->belongsToMany('App\Models\Order');
	}

	public function promotion()
	{
		return $this->hasOne('App\Models\Promotion');
	}

	public function resturant()
	{
		return $this->belongsTo('App\Models\Resturant');
	}

	public function meal_attributes()
	{
		return $this->hasMany('App\Models\MealAttribute');
	}

}