<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCustomersTable extends Migration {

	public function up()
	{
		Schema::create('customers', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name');
			$table->string('email')->nullable();
			$table->string('password')->nullable();
			$table->string('phone_number');
			$table->string('address')->nullable();
			$table->string('provider_id')->nullable();
			$table->string('provider')->nullable();
			$table->integer('is_active_phone')->default('0');
			$table->text('latitude')->nullable();
			$table->text('longitude')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('customers');
	}
}