<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateWinchesTable extends Migration {

	public function up()
	{
		Schema::create('winches', function(Blueprint $table) {
			$table->bigInteger('id');
			$table->string('name_ar')->nullable();
			$table->string('name_en')->nullable();
			$table->text('description_ar')->nullable();
			$table->text('description_en')->nullable();
			$table->string('logo')->nullable();
			$table->string('record_number')->nullable();
			$table->boolean('active')->default(true);
			$table->boolean('availablity')->default(true);
			$table->enum('status', array('available', 'busy', 'out_of_service'));
			$table->enum('place_type', array('local', 'external', 'khaliji'));
			$table->enum('type', array('winch', 'rescue_car'));
			$table->bigInteger('country_id')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('winches');
	}
}