<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSpecialNumbersTable extends Migration {

	public function up()
	{
		Schema::create('special_numbers', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->string('number')->nullable();
			$table->bigInteger('special_number_category_id')->unsigned();
			$table->bigInteger('selling_special_number_id')->unsigned()->nullable();
			$table->boolean('availabilty')->default(true);
			$table->boolean('active')->default(true);
			$table->string('size')->nullable();
			$table->string('transition_type')->nullable();
			$table->boolean('include_insurance')->default(true);
			$table->double('price', 8,2)->nullable();
			$table->bigInteger('user_id')->unsigned()->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('special_numbers');
	}
}