<?php

namespace Model;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class States extends Eloquent {

	protected $table = 'states';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'country_id');

	public function city()
	{
		return $this->hasMany('Model\City', 'state_id');
	}

}