<?php

namespace Model;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class CandidatePolliingArea extends Model 
{

    protected $table = 'candidate_polling_areas';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('election_polling_area_id');

    public function polling()
    {
        return $this->belongsTo('ElectionPollingArea', 'polling_area_id');
    }

    public function candidate()
    {
        return $this->belongsTo('Model\Candidate', 'candidate_id');
    }

}