<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTransactionTable extends Migration {

	public function up()
	{
		Schema::create('transaction', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id');
			$table->string('order_id', 191)->unique();
			$table->decimal('amount');
			$table->tinyInteger('payment_type')->default('1');
			$table->tinyInteger('gateway_type');
			$table->json('response_json');
			$table->tinyInteger('status')->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('transaction');
	}
}