<?php

namespace models;

use Illuminate\Database\Eloquent\Model;

class Post extends Model 
{

    protected $table = 'posts';
    public $timestamps = true;
    protected $fillable = array('title', 'content', 'image', 'client_id');

    public function Client()
    {
        return $this->belongsTo('models\Client', 'client_id');
    }

    public function Clients()
    {
        return $this->belongsToMany('models\Client', 'client_id');
    }

    public function Category()
    {
        return $this->belongsTo('models\Category', 'category_id');
    }

}