<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateConfirmationsTable extends Migration {

	public function up()
	{
		Schema::create('confirmations', function(Blueprint $table) {
			$table->bigIncrements('id', true);
			$table->integer('companyName')->unsigned();
			$table->integer('accountNameFrom')->unsigned();
			$table->integer('accountNumberFrom')->unsigned();
			$table->integer('bankNameFrom')->unsigned()->default('NULL');
			$table->integer('accountNameTo');
			$table->integer('accountNumberTo')->unsigned();
			$table->integer('bankNameTo')->unsigned();
			$table->string('photo', 255)->unique()->default('NULL');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('confirmations');
	}
}