<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCompaniesTable extends Migration {

	public function up()
	{
		Schema::create('companies', function(Blueprint $table) {
			$table->bigIncrements('id', true);
			$table->bigInteger('orderID');
			$table->string('name', 255)->default('NULL');
			$table->string('businessPurpose', 255)->nullable()->default('NULL');
			$table->string('nationality', 255)->nullable()->default('NULL');
			$table->integer('capitalMin')->default('NULL');
			$table->string('capitalMax', 255)->default('NULL');
			$table->longText('capitalNotes')->unique()->nullable();
			$table->integer('numberOfShareholder')->nullable()->default('NULL');
			$table->integer('numberOfDirector')->default('NULL');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('companies');
	}
}