<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Bill extends Model 
{

    protected $table = 'bills';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function customer()
    {
        return $this->belongsTo('Customer');
    }

    public function products()
    {
        return $this->belongsToMany('Product', 'bill_products')->withTimestamps();
    }

}