<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProjectsTable extends Migration {

	public function up()
	{
		Schema::create('Projects', function(Blueprint $table) {
			$table->increments('project_id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('project_name', 100);
			$table->string('project_description', 500)->nullable();
			$table->date('start_date');
			$table->date('end_date');
			$table->string('budget_code', 30);
		});
	}

	public function down()
	{
		Schema::drop('Projects');
	}
}