<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('championships', function(Blueprint $table) {
			$table->foreign('pointschem_id')->references('id')->on('pointschemes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('events', function(Blueprint $table) {
			$table->foreign('track_id')->references('id')->on('tracks')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('events', function(Blueprint $table) {
			$table->foreign('championship_id')->references('id')->on('championships')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('races', function(Blueprint $table) {
			$table->foreign('event_id')->references('id')->on('events')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('qualys', function(Blueprint $table) {
			$table->foreign('event_id')->references('id')->on('events')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('practices', function(Blueprint $table) {
			$table->foreign('event_id')->references('id')->on('events')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('championships', function(Blueprint $table) {
			$table->dropForeign('championships_pointschem_id_foreign');
		});
		Schema::table('events', function(Blueprint $table) {
			$table->dropForeign('events_track_id_foreign');
		});
		Schema::table('events', function(Blueprint $table) {
			$table->dropForeign('events_championship_id_foreign');
		});
		Schema::table('races', function(Blueprint $table) {
			$table->dropForeign('races_event_id_foreign');
		});
		Schema::table('qualys', function(Blueprint $table) {
			$table->dropForeign('qualys_event_id_foreign');
		});
		Schema::table('practices', function(Blueprint $table) {
			$table->dropForeign('practices_event_id_foreign');
		});
	}
}